***********************************************************************
*** Table E2: Alternative transformations ***
************************************************************************                
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

bysort country_id : gen dglobal_real_credit = log(global_real_credit) - log(L4.global_real_credit)
bysort country_id : gen dglobal_real_hp = log(global_real_hp) - log(L4.global_real_hp)
bysort country_id : gen dglobal_credit_gdp = (global_credit_gdp - L4.global_credit_gdp)
bysort country_id : gen dglobal_hp_inc = (global_hp_inc - l4.global_hp_inc)
label variable dglobal_credit_gdp "Global credit-to-GDP (yd)"
label variable dglobal_hp_inc "Global house prices-to-income (yd)"
label variable dlogreal_hcredit "Real household credit growth(yoy)"
label variable dlogreal_nfecredit "Real firm credit growth(yoy)"
label variable dlogrGDP "Real GDP growth(yoy)"
label variable dglobal_real_credit "Global real credit growth(yoy)"
label variable dglobal_real_hp "Global real house price growth (yoy)"

*Column(1)
logit crisis4_12 dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dlogrGDP i.country_id, robust cluster(period)
est store pa5
predict pa5, p
roctab crisis4_12 pa5
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 20
estadd scalar Crisis = 29

*Column(2)
logit crisis4_12 dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dglobal_real_credit dglobal_real_hp dlogrGDP i.country_id, robust cluster(period)
est store pa6
predict pa6, p
roctab crisis4_12 pa6
estadd scalar AUROC = r(area)
estadd scalar Countries = 17
estadd scalar Crisis = 25

*Column(3)
logit crisis4_12 dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dglobal_real_credit dglobal_real_hp  ind_hp_inc_exu ind_credit_gdp_exu dlogrGDP i.country_id, robust cluster(period)
est store pa7
predict pa7, p
roctab crisis4_12 pa7
estadd scalar AUROC = r(area)
estadd scalar Countries = 15
estadd scalar Crisis = 22

*Column(4)
logit crisis4_12 dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dglobal_real_credit dglobal_real_hp  dwholesale_assets equity_assets ind_hp_inc_exu ind_credit_gdp_exu dlogrGDP i.country_id, robust cluster(period)
est store pa8
predict pa8, p
roctab crisis4_12 pa8
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19

cd "$outputTables"
esttab pa5 pa6 pa7 pa8 using TableE2.tex, se indicate("Country fixed effects = *country_id") drop(_cons) ///
						order(dlogreal_hcredit dlogreal_nfecredit dglobal_real_credit dglobal_real_hp ind_hp_inc_exu ind_credit_gdp_exu dwholesale_assets equity_assets dlogreal_hp dlogrGDP)  ///
						star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
						label scalars("r2_p Pseudo R-Squared" AUROC Countries Crisis) ///
						nodepvars nonotes replace

